//
//  FSLabelTransformer.m
//  SimpleSearchApp
//
//  Created by ub on 25.07.09.
//  Copyright 2009 Udo Borkowski. All rights reserved.
//

#import "FSLabelToColorNameTransformer.h"


@implementation FSLabelToColorNameTransformer

+ (Class)transformedValueClass {
    return [NSString class];
}

- (id)transformedValue:(id)value {
    if (value == nil) {
		return @"Undefined";
    }
    if (![value respondsToSelector:@selector(integerValue)]) {
        [NSException raise:NSInternalInconsistencyException format:@"Value %@ does not respond to integerValue", [value class]];
    }
	
    NSInteger val = [value integerValue];
	switch (val) {
		case 0:
			return @"None";
			break;
		case 1:
			return @"Gray";
			break;
		case 2:
			return @"Green";
			break;
		case 3:
			return @"Purple";
			break;
		case 4:
			return @"Blue";
			break;
		case 5:
			return @"Yellow";
			break;
		case 6:
			return @"Red";
			break;
		case 7:
			return @"Orange";
			break;
		default:
			return @"Unknown";
	}
}

@end
